import time
import allure

from pages.popups_page import PopupsPage
from tests.base_test import BaseTest


@allure.epic("Модальные окна")
class TestPopupsPage(BaseTest):

    def setup_method(self):
        self.popups_page = PopupsPage(self.driver)
        self.popups_page.open()


    @allure.feature("Alert Popup")
    @allure.title("Тест Alert всплывающего окна")
    def test_alert_popup(self):
        try:
            with allure.step("Кликнуть на кнопку Alert Popup"):
                self.popups_page.click_alert_button()

            with allure.step("Получить текст из alert"):
                alert_text = self.popups_page.get_alert_text()

            with allure.step("Проверить текст alert"):
                assert alert_text == "Hi there, pal!", f"Ожидался 'Hi there, pal!', получен '{alert_text}'"
        except Exception as e:
            self.allure_screenshot()
            raise e

    @allure.feature("Confirm Popup")
    @allure.title("Тест Confirm всплывающего окна - принятие")
    def test_confirm_popup_ok(self):
        try:
            with allure.step("Кликнуть на кнопку Confirm Popup"):
                self.popups_page.click_confirm_button()

            with allure.step("Принять confirm alert"):
                self.popups_page.handle_confirm_alert(accept=True)

            with allure.step("Проверить результат подтверждения"):
                result = self.popups_page.get_confirm_result()
                assert result == "OK it is!"
        except Exception as e:
            self.allure_screenshot()
            raise e

    @allure.feature("Confirm Popup")
    @allure.title("Тест Confirm всплывающего окна - отмена")
    def test_confirm_popup_cancel(self):
        try:
            with allure.step("Кликнуть на кнопку Confirm Popup"):
                self.popups_page.click_confirm_button()

            with allure.step("Отклонить confirm alert"):
                self.popups_page.handle_confirm_alert(accept=False)

            with allure.step("Проверить результат отмены"):
                result = self.popups_page.get_confirm_result()
                assert result == "Cancel it is!"
        except Exception as e:
            self.allure_screenshot()
            raise e

    @allure.feature("Prompt Popup")
    @allure.title("Тест Prompt всплывающего окна с текстом")
    def test_prompt_popup_with_text(self):
        try:
            test_name = "John"

            with allure.step("Кликнуть на кнопку Prompt Popup"):
                self.popups_page.click_prompt_button()

            with allure.step(f"Ввести текст '{test_name}' в prompt"):
                self.popups_page.handle_prompt_alert(text=test_name)

            with allure.step("Проверить результат"):
                result = self.popups_page.get_prompt_result()
                expected_text = f"Nice to meet you, {test_name}!"
                assert result == expected_text
        except Exception as e:
            self.allure_screenshot()
            raise e

    @allure.feature("Prompt Popup")
    @allure.title("Тест Prompt всплывающего окна без текста")
    def test_prompt_popup_empty(self):
        try:
            with allure.step("Кликнуть на кнопку Prompt Popup"):
                self.popups_page.click_prompt_button()

            with allure.step("Не вводить текст в prompt"):
                self.popups_page.handle_prompt_alert(text=None)

            with allure.step("Проверить результат для пустого ввода"):
                result = self.popups_page.get_prompt_result()
                assert result == "Fine, be that way..."
        except Exception as e:
            self.allure_screenshot()
            raise e

    @allure.feature("Tooltip")
    @allure.title("Тест Tooltip")
    def test_tooltip(self):
        try:
            with allure.step("Проверить, что Tooltip изначально скрыт"):
                assert not self.popups_page.is_tooltip_visible()

            with allure.step("Кликнуть на элемент Tooltip"):
                self.popups_page.click_tooltip()

            with allure.step("Дождаться появления Tooltip"):
                self.popups_page.wait_for_tooltip_visible()

            with allure.step("Проверить видимость и текст Tooltip"):
                assert self.popups_page.is_tooltip_visible()
                assert self.popups_page.get_tooltip_text() == "Cool text"

            with allure.step("Скрыть Tooltip"):
                self.popups_page.click_tooltip()
                self.popups_page.wait_for_tooltip_hidden()

            with allure.step("Проверить, что Tooltip скрыт"):
                assert not self.popups_page.is_tooltip_visible()

        except Exception as e:
            self.allure_screenshot()
            raise e